//********************************************************************
//  Sphere.java       Author: Lewis and Loftus
//
//  Solution to Programming Project 4.1 (5E, p. 202)
//********************************************************************

import java.text.DecimalFormat;

public class Sphere
{
   private double diameter;

   //-----------------------------------------------------------------
   //  Sets up this Sphere object with the specified diameter.
   //-----------------------------------------------------------------
   public Sphere (double size)
   {
      diameter = size;
   }

   //-----------------------------------------------------------------
   //  Returns this sphere's diameter.
   //-----------------------------------------------------------------
   public double getDiameter ()
   {
	   return diameter;
   }

   //-----------------------------------------------------------------
   //  Sets this sphere's diameter.
   //-----------------------------------------------------------------
   public void setDiameter (double size)
   {
	   diameter = size;
   }

   //-----------------------------------------------------------------
   //  Computes and returns the volume of this sphere.
   //-----------------------------------------------------------------
   public double volume ()
   {
      return 4.0 / 3.0 * Math.PI * Math.pow(diameter/2, 3);
   }

   //-----------------------------------------------------------------
   //  Computes and returns the area of this sphere.
   //-----------------------------------------------------------------
   public double area ()
   {
      return 4 * Math.PI * Math.pow(diameter/2, 2);
   }

   //-----------------------------------------------------------------
   //  Returns a string representation of this sphere.
   //-----------------------------------------------------------------
   public String toString ()
   {
	  DecimalFormat fmt = new DecimalFormat ("0.###");
	
      return "Sphere diameter: " + diameter + "   volume: " + 
             fmt.format(volume()) + "    area: " + fmt.format(area());
   }
}
